﻿Imports FusionWare.DirectADO
Imports FusionWare.Common
Imports System.Data
Imports System.ComponentModel
Imports System
Imports System.Windows.Forms

<System.ComponentModel.DataObject()> _
Public Class SalesOrder
    Const TABLE_NAME As String = "SALESORDER"
    Public Property ConnectionString As String = "Data Source=localhost;Location=MANU_POS;User Id=direct;Password=fusionware;Timeout=20;Diags On=1;Trace On=1;Login Script=""/MSuser name;/T5000;/MXNo user name prompt;/U;/MSpassword;/T5000;/MXNo password prompt;/P;/MSEnter Location;/T5000;/MXNo Enter Location prompt;/L;"""

    Public Sub New()
        ConnectionString = "Data Source=localhost;Location=MANU_POS;User Id=direct;Password=fusionware;Timeout=20;Diags On=1;Trace On=1;Login Script=""/MSuser name;/T5000;/MXNo user name prompt;/U;/MSpassword;/T5000;/MXNo password prompt;/P;/MSEnter Location;/T5000;/MXNo Enter Location prompt;/L;"""
    End Sub

    Public Sub New(ByVal sConnectionString As String)
        ConnectionString = sConnectionString
    End Sub


    Private Function getSalesOrders(ByVal commandText As String) As SALESORDERDataSet
        Dim command As New FWMVCommand
        Dim dsSalesOrder As New SALESORDERDataSet

        Using adapter As New FWMVDataAdapter
            Using Connection As New FWMVConnection
                Connection.ConnectionString = ConnectionString
                command.Connection = Connection
                command.CommandText = commandText
                adapter.SelectCommand = command
                adapter.Fill(dsSalesOrder, TABLE_NAME)
                Return dsSalesOrder
            End Using
        End Using
    End Function

    ' The boolean parameter on the end indicates that this
    ' method is the default Select method
    <System.ComponentModel.DataObjectMethodAttribute _
           (System.ComponentModel.DataObjectMethodType.Select, True)> _
    Public Function getSalesOrders() As SALESORDERDataSet

        Return getSalesOrders(TABLE_NAME)
    End Function

    ' This is another Select method, but not the default
    <System.ComponentModel.DataObjectMethodAttribute _
           (System.ComponentModel.DataObjectMethodType.Select, False)> _
    Public Function getSalesOrdersBySelect(ByVal selectCommand As String) As SALESORDERDataSet

        Dim commandText As String = TABLE_NAME + " " + StringTokenizer.DoubleQuoteString(selectCommand)
        Return getSalesOrders(commandText)
    End Function

    <System.ComponentModel.DataObjectMethodAttribute _
           (System.ComponentModel.DataObjectMethodType.Select, False)> _
    Public Function getSalesOrderById(ByVal salesOrderId As String) As SALESORDERDataSet

        Dim commandText As String = TABLE_NAME + " '' " + StringTokenizer.DoubleQuoteString(salesOrderId)
        Return getSalesOrders(commandText)
    End Function

    ' This is the default update method 
    <System.ComponentModel.DataObjectMethodAttribute _
           (System.ComponentModel.DataObjectMethodType.Update, False)> _
    Public Sub updateSalesOrderData(ByVal dsSalesOrder As SALESORDERDataSet)

        Using adapter As New FWMVDataAdapter
            Using connection As New FWMVConnection
                connection.ConnectionString = ConnectionString
                connection.Open()
                Using Command As New FWMVCommand
                    Command.Connection = connection
                    ' This loads metadata into the command object
                    Command.CommandText = TABLE_NAME & " '' '~~~THIS ITEM DOES NOT EXIST~~~'"
                    Command.ExecuteReader().Close()
                    ' Assign the command to the adapter
                    adapter.SelectCommand = Command
                    ' And tell the adapter to do the update for us
                    adapter.Update(dsSalesOrder)
                End Using
            End Using
        End Using
    End Sub

    <System.ComponentModel.DataObjectMethodAttribute _
           (System.ComponentModel.DataObjectMethodType.Update, False)> _
    Public Sub updateSalesOrderUrgent(ByVal SalesOrderNumber As String)
        Using adapter As New FWMVDataAdapter
            Using connection As New FWMVConnection
                connection.ConnectionString = ConnectionString
                connection.Open()
                Using Command As New FWMVCommand
                    Command.Connection = connection
                    ' This loads metadata into the command object
                    Command.CommandText = "EXEC SP CHANGE.SALESORDER.URGENCY """ & SalesOrderNumber & """"
                    Command.ExecuteNonQuery()
                End Using
            End Using
        End Using
    End Sub
End Class