﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// Added for REST 
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Xml;
using System.ServiceModel.Activation;
using SALESORDER_DAL;



namespace SalesOrderREST
{
    [ServiceContract(Name = "SalesOrderREST")]
    public interface ISalesOrderREST
    {
        [OperationContract]
        [WebGet(UriTemplate = Routing.GetSalesOrderRoute, BodyStyle = WebMessageBodyStyle.Bare)]
        XmlElement GetSalesOrderByOrderNumber(string salesOrderNumber);

        [OperationContract]
        [WebGet(UriTemplate = Routing.GetSalesOrderByCustomerRoute, BodyStyle = WebMessageBodyStyle.Bare)]
        XmlElement GetSalesOrdersByCustomer(string customerId);

        [OperationContract]
        [WebGet(UriTemplate = Routing.UpdateSalesOrderUrgencyRoute, BodyStyle = WebMessageBodyStyle.Bare)]
        XmlElement UpdateSalesOrderUrgency(string salesOrderNumber);
    }

    public static class Routing
    {
        public const string GetSalesOrderRoute = "/SalesOrder/{salesOrderNumber}";
        public const string GetSalesOrderByCustomerRoute = "/SalesOrder/Customer/{customerId}";
        public const string UpdateSalesOrderUrgencyRoute = "/SalesOrder/Urgent/{salesOrderNumber}";
    }

    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single,
        ConcurrencyMode = ConcurrencyMode.Single,
        IncludeExceptionDetailInFaults = true)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class SalesOrderREST : ISalesOrderREST
    {
        public SalesOrder salesOrders = new SalesOrder();

        #region ISalesOrderREST Members

        public XmlElement GetSalesOrderByOrderNumber(string salesOrderNumber)
        {
            SALESORDERDataSet ds = salesOrders.getSalesOrderById(salesOrderNumber);
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(ds.GetXml());
            return (XmlElement)doc.DocumentElement.SelectSingleNode("SALESORDER");
        }

        public XmlElement GetSalesOrdersByCustomer(string customerId)
        {
            string selectCommand = string.Format(
                "SSELECT SALESORDER WITH CUSTOMER = \"{0}\"",
                customerId.Replace("\"", "\"\"")
                );
            SALESORDERDataSet ds = salesOrders.getSalesOrdersBySelect(selectCommand);
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(ds.GetXml());
            return (XmlElement)doc.DocumentElement;
        }

        public XmlElement  UpdateSalesOrderUrgency(string salesOrderNumber)
        {
            try
            {
                salesOrders.updateSalesOrderUrgent(salesOrderNumber);
                XmlDocument doc = new XmlDocument();
                doc.LoadXml("<ChangeSALESORDER_Urgency>1</ChangeSALESORDER_Urgency>");
                return (XmlElement)doc.DocumentElement;
            }
            catch (Exception ex)
                {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml("<ChangeSALESORDER_Urgency>0</ChangeSALESORDER_Urgency>");
                return (XmlElement)doc.DocumentElement;
                }
            
        }

        #endregion
    }
}



