﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Xml.Linq;



namespace SalesOrderWP7
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        String requestString = "http://localhost:53791/WebSite7/SalesOrderREST.svc/SalesOrder/{0}{1}";
        String requestStringUrgent = "http://localhost:53791/WebSite7/SalesOrderREST.svc/SalesOrder/Urgent/{0}{1}";
        WebClient wc;
        WebClient wcU;

        public MainPage()
        {
            InitializeComponent();
            try
            {
                //processDataSet(ws);
                wc = new WebClient();
                wc.OpenReadCompleted += new OpenReadCompletedEventHandler(wc_OpenReadCompleted);
                wcU = new WebClient();
                wcU.OpenReadCompleted += new OpenReadCompletedEventHandler(wcU_OpenReadCompleted);
            }


            catch (Exception ex)
            {

                Console.Error.WriteLine(ex.ToString());

            }

            finally
            {

                Console.Write("Press Enter to finish... ");

                Console.ReadLine();

            }

        }

        void wcU_OpenReadCompleted(object sender, OpenReadCompletedEventArgs e)
        {
            XElement resultXml;
            if (e.Error != null)
            {
                return;
            }
            resultXml = XElement.Load(e.Result);
            wc.OpenReadAsync(new Uri(String.Format(requestString, textBox1.Text, "?junk=" + DateTime.Now)));
        }


        void wc_OpenReadCompleted(object sender, OpenReadCompletedEventArgs e)
        {
            XElement resultXml;
            if (e.Error != null)
            {
                return;
            }
            else
            {
                try
                {
                    resultXml = XElement.Load(e.Result);
                    // Search for the WebResult node and create a SearchResults object for each one.
                    //var searchResults = from result in resultXml.Descendants("SALESORDER")
                    //select new SearchResult
                    //    {
                    //        // Get the Title, Description and Url values.
                    //        OrderNumber = result.Element("OrderNumber").Value,
                    //        Customer = result.Element("Customer").Value,
                    //        DateOrderPlaced = result.Element("DateOrderPlaced").Value
                    //    };
                    var searchResult = new SearchResult
                    {
                        OrderNumber = resultXml.Element("OrderNumber").Value,
                        Customer = resultXml.Element("Customer").Value,
                        DateOrderPlaced = resultXml.Element("DateOrderPlaced").Value,
                        Urgent = resultXml.Element("Urgent").Value
                    };
                    string Urgent = searchResult.Urgent == "1" ? "True" : "False";
                    textBlock1.Text = "Customer No: " + searchResult.Customer 
                            + "\r\n" + "Date of Order: " + searchResult.DateOrderPlaced
                            + "\r\n" + "Urgent? " + Urgent ;
                    if (searchResult.Urgent == "1")
                    {
                        button2.Content = "Not Urgent";
                        button2.BorderBrush = new SolidColorBrush(Colors.Green);
                        button2.Foreground = new SolidColorBrush(Colors.Green);
                    }
                    else
                    {
                        button2.Content = "Urgent";
                        button2.BorderBrush = new SolidColorBrush(Colors.Red);
                        button2.Foreground = new SolidColorBrush(Colors.Red);
                    }

                    // Set the data context for the listbox to the results.
                }
                catch (System.Xml.XmlException ex)
                {
                    textBlock1.Text = ex.Message;
                }
            }
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            wc.OpenReadAsync(new Uri(String.Format(requestString,textBox1.Text, "?junk=" + DateTime.Now)));
        }

        // Simple class to hold the search results.
        public class SearchResult
        {
            public string OrderNumber { get; set; }
            public string Customer { get; set; }
            public string DateOrderPlaced { get; set; }
            public string Urgent { get; set; }
        }

        private void button2_Click(object sender, RoutedEventArgs e)
        {
            wcU.OpenReadAsync(new Uri(String.Format(requestStringUrgent, textBox1.Text, "?junk=" + DateTime.Now)));
        }




    }

}


